function [K,P,gamma] = Step1_Controller_design(A,B,D,Mc,Nc,Cx)

[n,m] = size(B);
[~,l] = size(D);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
gamma0 = sdpvar(1);
M0 = sdpvar(m,n);
P0 = sdpvar(n,n);

LMI1 = blkvar();
LMI1(1,1) = (A*P0+B*M0)+(A*P0+B*M0)';
LMI1(1,2) = D;
LMI1(1,3) = Mc;
LMI1(1,4) = P0*Nc';
LMI1(1,5) = P0*Cx';

LMI1(2,2) = -gamma0*eye(l);
LMI1(2,3) = zeros(l,n);
LMI1(2,4) = zeros(l,n);
LMI1(2,5) = zeros(l,n);

LMI1(3,3) = -eye(n);
LMI1(3,4) = zeros(n,n);
LMI1(3,5) = zeros(n,n);

LMI1(4,4) = -eye(n);
LMI1(4,5) = zeros(n,n);

LMI1(5,5) = -gamma0*eye(n);

LMI1 = sdpvar(LMI1);


const = [];
% objective = gamma0;
objective = 1.0e-3*gamma0;
const = [const, P0 >= eps*eye(n)];
const = [const, gamma0 >= 0];
const = [const, LMI1 <= -eps*eye(4*n+l)];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%5
ops = sdpsettings('solver','mosek','verbose','0');
optimize(const,objective,ops);

K =  value(M0)*inv(value(P0));
P = value(P0);
gamma = value(gamma0);


